<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContentUpdate extends Model 
{

    protected $table = 'content_update';
    public $timestamps = true;
    protected $fillable = array('node_id', 'name', 'audio_content_action', 'audio_content_id', 'audio_campaign_action', 'audio_campaign_id', 'video_content_action', 'video_content_id', 'video_campaign_action', 'video_campaign_id', 'stream_id', 'stream_action');

    public function node()
    {
        return $this->belongsTo('App\Models\Node');
    }

    public function audioContent()
    {
        return $this->belongsTo('App\Models\Content', 'audio_content_id');
    }

    public function videoContent()
    {
        return $this->belongsTo('App\Models\Content', 'video_content_id');
    }

    public function stream()
    {
        return $this->belongsTo('App\Models\Stream');
    }

    public function audioCampaign()
    {
        return $this->belongsTo('App\Models\Campaign', 'audio_campaign_id');
    }

    public function videoCampaign()
    {
        return $this->belongsTo('App\Models\Campaign', 'video_campaign_id');
    }

}